<?php
require_once 'conn.php';
header('Content-Type: application/json');

// --- Check for DELETE method ---
if ($_SERVER['REQUEST_METHOD'] !== 'DELETE') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// --- Read Authorization Header ---
$headers = function_exists('apache_request_headers') ? apache_request_headers() : [];
$authHeader = isset($_SERVER['HTTP_AUTHORIZATION']) ? $_SERVER['HTTP_AUTHORIZATION'] : ($headers['Authorization'] ?? '');

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or invalid Authorization token.']);
    exit();
}

$token = $matches[1];

// --- Validate Token ---
$tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$tokenQuery || $tokenQuery->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Invalid token.']);
    exit();
}

// --- Parse Input for product_id ---
parse_str(file_get_contents("php://input"), $data);

if (!isset($data['product_id']) || empty($data['product_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Product ID is required.']);
    exit();
}

$product_id = mysqli_real_escape_string($con, $data['product_id']);

// --- Check if Product Exists ---
$check = $con->query("SELECT * FROM product WHERE product_id = '$product_id'");
if (!$check || $check->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'Product not found.']);
    exit();
}

// --- Delete Product ---
$delete = $con->query("DELETE FROM product WHERE product_id = '$product_id'");

if ($delete) {
    echo json_encode(['status' => 'success', 'message' => 'Product deleted successfully.']);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to delete product.']);
}
?>
