<?php 
require_once 'conn.php';
header('Content-Type: application/json');

// Token validation
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if ($authHeader) {
    if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $token = $matches[1];

        $tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
        if (!$tokenQuery || $tokenQuery->num_rows === 0) {
            http_response_code(401);
            echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
            exit();
        }

        // Optional: $user = $tokenQuery->fetch_assoc();
    } else {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Malformed Authorization header.']);
        exit();
    }
} else {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token is missing.']);
    exit();
}

// Allow only DELETE requests
if ($_SERVER['REQUEST_METHOD'] !== 'DELETE') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// Read raw DELETE input as JSON
$data = json_decode(file_get_contents("php://input"), true);

// Check required field
if (empty($data['kyc_id']) && empty($data['user_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'kyc_id or user_id is required.']);
    exit();
}

if (!empty($data['kyc_id'])) {
    $kyc_id = mysqli_real_escape_string($con, $data['kyc_id']);
    $delete = $con->query("DELETE FROM user_kyc WHERE kyc_id = '$kyc_id'");
} else {
    $user_id = mysqli_real_escape_string($con, $data['user_id']);
    $delete = $con->query("DELETE FROM user_kyc WHERE user_id = '$user_id'");
}

if ($delete) {
    echo json_encode(['status' => 'success', 'message' => 'KYC record deleted successfully.']);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to delete KYC record.', 'error' => $con->error]);
}
?>
