<?php
require_once 'conn.php';

header('Content-Type: application/json');

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

// Check for Bearer token
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if ($authHeader && preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    $token = $matches[1];
    $userQuery = $con->query("SELECT user_id, full_name, email FROM users WHERE auth_token = '$token'");

    if (!$userQuery || $userQuery->num_rows === 0) {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Invalid token']);
        exit();
    }

    $user = $userQuery->fetch_assoc();
    $user_id = $user['user_id'];
    $user_email = $user['email'];
    $user_name = $user['full_name'];
} else {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header']);
    exit();
}

// Allow only DELETE method
if ($_SERVER['REQUEST_METHOD'] !== 'DELETE') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Only DELETE method is allowed']);
    exit();
}

// Parse raw input (DELETE doesn't use $_POST)
$input = json_decode(file_get_contents("php://input"), true);

if (empty($input['book_hotel_id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'book_hotel_id is required']);
    exit();
}

$book_hotel_id = $con->real_escape_string($input['book_hotel_id']);

// Check if booking belongs to user
$check = $con->query("SELECT * FROM hotel_bookings WHERE book_hotel_id = '$book_hotel_id' AND user_id = '$user_id'");

if ($check->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'Booking not found or not yours']);
    exit();
}

// Delete the booking
$delete = $con->query("DELETE FROM hotel_bookings WHERE book_hotel_id = '$book_hotel_id' AND user_id = '$user_id'");

if ($delete) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Hotel booking deleted successfully',
        'book_hotel_id' => $book_hotel_id
    ]);
} else {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to delete booking',
        'error' => $con->error
    ]);
}
?>
