<?php
require_once 'conn.php'; // Your DB connection
header('Content-Type: application/json');

// Token validation
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if ($authHeader) {
    if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $token = $matches[1];

        $tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
        if (!$tokenQuery || $tokenQuery->num_rows === 0) {
            http_response_code(401);
            echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
            exit();
        }

        // Optional: $user = $tokenQuery->fetch_assoc();
    } else {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Malformed Authorization header.']);
        exit();
    }
} else {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token is missing.']);
    exit();
}

// Only allow DELETE requests
if ($_SERVER['REQUEST_METHOD'] !== 'DELETE') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// Read raw input
$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['cat_id'])) {
    http_response_code(400); // Bad Request
    echo json_encode(['status' => 'error', 'message' => 'Category ID (cat_id) is required.']);
    exit();
}

// Sanitize
$cat_id = mysqli_real_escape_string($con, $data['cat_id']);

// Delete the category
$delete_sql = "DELETE FROM categories WHERE cat_id = '$cat_id'";
if ($con->query($delete_sql)) {
    echo json_encode(['status' => 'success', 'message' => 'Category deleted successfully.']);
} else {
    http_response_code(500); // Internal Server Error
    echo json_encode(['status' => 'error', 'message' => 'Failed to delete category.', 'error' => $con->error]);
}
?>
