<?php
require_once 'conn.php';
header('Content-Type: application/json');

// ✅ Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Only GET method is allowed.']);
    exit();
}

// ✅ Check for Bearer token in Authorization header
$authHeader = '';
if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
} elseif (function_exists('apache_request_headers')) {
    $headers = apache_request_headers();
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
    }
}

if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header.']);
    exit();
}

$token = $matches[1];

// ✅ Validate token
$check = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$check || $check->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized. Invalid token.']);
    exit();
}

// ✅ Run summary queries
$totalUsers      = $con->query("SELECT COUNT(*) AS count FROM users")->fetch_assoc()['count'];
$totalRiders     = $con->query("SELECT COUNT(*) AS count FROM users WHERE role = 'rider'")->fetch_assoc()['count'];
$totalKyc        = $con->query("SELECT COUNT(*) AS count FROM user_kyc")->fetch_assoc()['count'];
$totalCategories = $con->query("SELECT COUNT(*) AS count FROM categories")->fetch_assoc()['count'];
$totalSubcats    = $con->query("SELECT COUNT(*) AS count FROM subcat")->fetch_assoc()['count'];
$totalbusiness    = $con->query("SELECT COUNT(*) AS count FROM business_profiles")->fetch_assoc()['count'];

// ✅ Return dashboard data
echo json_encode([
    'status' => 'success',
    'dashboard' => [
        'total_users'      => (int) $totalUsers,
        'total_riders'     => (int) $totalRiders,
        'total_kyc'        => (int) $totalKyc,
        'total_categories' => (int) $totalCategories,
        'total_subcats'    => (int) $totalSubcats,
         'total_business'    => (int) $totalbusiness
    ]
]);
?>
