<?php
require_once 'conn.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

header('Content-Type: application/json');

// 🔐 Token Auth
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or invalid token']);
    exit();
}
$token = $matches[1];

// 📥 Get request data
$data = json_decode(file_get_contents("php://input"), true);
$user_id = mysqli_real_escape_string($con, $data['user_id'] ?? '');
$old_password = trim($data['old_password'] ?? '');
$new_password = trim($data['new_password'] ?? '');
$confirm_password = trim($data['confirm_password'] ?? '');
$otp = trim($data['otp'] ?? '');

// ✅ Validate required fields
if (empty($user_id) || empty($old_password) || empty($new_password) || empty($confirm_password) || empty($otp)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'All fields are required.']);
    exit();
}

// 🔐 Validate token and user match
$userQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token' AND user_id = '$user_id'");
if (!$userQuery || $userQuery->num_rows === 0) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized or invalid user.']);
    exit();
}

$user = $userQuery->fetch_assoc();
$user_email = $user['email'];
$user_name = $user['name'];

// 🔒 Validate old password
if ($old_password !== $user['password']) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Old password is incorrect.']);
    exit();
}

// 🔁 Prevent reuse of old password
if ($new_password === $old_password) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'You cannot use your old password as the new password.']);
    exit();
}

// ✅ Validate password match
if ($new_password !== $confirm_password) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'New passwords do not match.']);
    exit();
}

// 🔐 Check OTP
if ($otp !== $user['otp']) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Invalid OTP.']);
    exit();
}

// 💾 Update password
$update = $con->query("UPDATE users SET password = '$new_password', otp = NULL WHERE user_id = '$user_id'");

if ($update) {
    sendPasswordChangeEmail($user_email, $user_name);
    echo json_encode([
        'status' => 'success',
        'message' => 'Password changed successfully.'
    ]);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to update password.']);
}

// 📧 Send notification email
function sendPasswordChangeEmail($email, $name) {
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'mail.errandly.org';
        $mail->SMTPAuth = true;
        $mail->Username = 'info@errandly.org';
        $mail->Password = 'Zuo$cZs5}^7!';
        $mail->SMTPSecure = 'ssl';
        $mail->Port = 465;

        $mail->setFrom('info@errandly.org', 'Errandly');
        $mail->addAddress($email, $name);
        $mail->isHTML(true);
        $mail->Subject = 'Your Password Has Been Changed';
        $mail->Body = "
            <h3>Hello $name,</h3>
            <p>Your password has been changed successfully.</p>
            <p>If you did not initiate this change, please contact our support team immediately.</p>
            <br>
            <p>Best regards,<br>Errandly Team</p>
        ";

        $mail->send();
    } catch (Exception $e) {
        // Optional: Log error to file
    }
}
?>
