<?php
require_once 'conn.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

header('Content-Type: application/json');

function sendOtpToNewEmail($newEmail, $userName, $otp) {
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'mail.errandly.org';
        $mail->SMTPAuth = true;
        $mail->Username = 'info@errandly.org';
        $mail->Password = 'Zuo$cZs5}^7!';
        $mail->SMTPSecure = 'ssl';
        $mail->Port = 465;

        $mail->setFrom('info@errandly.org', 'Errandly');
        $mail->addAddress($newEmail);

        $mail->isHTML(true);
        $mail->Subject = 'Confirm Email Change - Errandly';
        $mail->Body = "Hi $userName,<br><br>Your OTP to confirm your email change is: <b>$otp</b>.<br>Please enter this OTP in the app to proceed.";

        $mail->send();
        return true;
    } catch (Exception $e) {
        return false;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $headers = apache_request_headers();
    $authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
    if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Authorization token missing or invalid.']);
        exit();
    }
    $token = $matches[1];

    $data = json_decode(file_get_contents('php://input'), true);
    if (!isset($data['user_id'], $data['new_email'])) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'user_id and new_email are required.']);
        exit();
    }

    $user_id = mysqli_real_escape_string($con, $data['user_id']);
    $new_email = mysqli_real_escape_string($con, $data['new_email']);

    if (!filter_var($new_email, FILTER_VALIDATE_EMAIL)) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Invalid email format.']);
        exit();
    }

    $userQuery = $con->query("SELECT * FROM users WHERE user_id = '$user_id' AND auth_token = '$token'");
    if (!$userQuery || $userQuery->num_rows === 0) {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Unauthorized or user not found.']);
        exit();
    }

    $user = $userQuery->fetch_assoc();
    $user_name = $user['name'];

    $check = $con->query("SELECT * FROM users WHERE email = '$new_email' AND user_id != '$user_id'");
    if ($check && $check->num_rows > 0) {
        http_response_code(409);
        echo json_encode(['status' => 'error', 'message' => 'This email is already in use.']);
        exit();
    }

    $otp = str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
    $update = $con->query("UPDATE users SET temp_email = '$new_email', otp = '$otp', is_verified = '0' WHERE user_id = '$user_id'");

    if ($update) {
    sendOtpToNewEmail($new_email, $user_name, $otp);

    // Fetch updated user info
    $fetchUpdatedUser = $con->query("SELECT * FROM users WHERE user_id = '$user_id'");
    $updatedUser = $fetchUpdatedUser->fetch_assoc();

    $imageUrl = 'https://errandly.org/errandly/uploads/user/' . ($updatedUser['user_image'] ?: 'placeholder.png');

    $userData = [
        'id' => $updatedUser['id'],
        'user_id' => $updatedUser['user_id'],
        'name' => $updatedUser['name'],
        'email' => $updatedUser['email'],
        'phone' => $updatedUser['phone'],
        'wallet' => $updatedUser['wallet'],
        'role' => $updatedUser['role'],
        'status' => $updatedUser['status'],
        'dob' => $updatedUser['dob'],
        'address' => $updatedUser['address'],
        'is_verified' => $updatedUser['is_verified'],
        'temp_email' => $updatedUser['temp_email'],
        'user_image' => $imageUrl,
        'kyc_status' => $user['kyc_status'],
        'kyc_submitted' => $user['kyc_submitted'],
        'acct_name' => $user['acct_name'],
        'acct_num' => $user['acct_num'],
    ];

    echo json_encode([
        'status' => 'success',
        'message' => 'OTP sent to new email for verification.',
        'user' => $userData
    ]);
}
else {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Failed to update email verification info.']);
    }
} else {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
?>
