<?php
require_once 'conn.php';
header('Content-Type: application/json');
// --- 1. Check request method ---
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method. Use GET.']);
    exit();
}

// --- Token validation ---
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
    exit();
}

$token = $matches[1];
$userResult = $con->query("SELECT user_id FROM users WHERE auth_token = '$token'");
if (!$userResult || $userResult->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized.']);
    exit();
}
$user_id = $userResult->fetch_assoc()['user_id'];

// --- Calculate total ---
$sql = $con->query("SELECT SUM(p.price * c.quantity) AS total 
                   FROM cart c 
                   JOIN products p ON c.product_id = p.product_id 
                   WHERE c.user_id = '$user_id'");
$row = $sql->fetch_assoc();

echo json_encode(['status' => 'success', 'total' => $row['total'] ?? 0]);
?>
