<?php
require_once 'conn.php';
header('Content-Type: application/json');

// 1. Token Validation
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing or invalid.']);
    exit();
}

$token = $matches[1];
$userQuery = $con->query("SELECT user_id FROM users WHERE auth_token = '$token'");
if (!$userQuery || $userQuery->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
    exit();
}
$user = $userQuery->fetch_assoc();
$user_id = $user['user_id'];

// 2. Method Check
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// 3. Get JSON Data
$data = json_decode(file_get_contents("php://input"), true);
$product_id = isset($data['product_id']) ? mysqli_real_escape_string($con, $data['product_id']) : '';
$quantity = isset($data['quantity']) ? (int)$data['quantity'] : 1;

if (empty($product_id) || $quantity < 1) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Product ID and quantity are required.']);
    exit();
}

// 4. Check if product exists
$productCheck = $con->query("SELECT * FROM products WHERE product_id = '$product_id'");
if (!$productCheck || $productCheck->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'Product not found.']);
    exit();
}

// 5. Check if product already in cart (update quantity if yes)
$cartCheck = $con->query("SELECT * FROM cart WHERE user_id = '$user_id' AND product_id = '$product_id'");
if ($cartCheck && $cartCheck->num_rows > 0) {
    $con->query("UPDATE cart SET quantity = quantity + $quantity WHERE user_id = '$user_id' AND product_id = '$product_id'");
    echo json_encode(['status' => 'success', 'message' => 'Cart updated successfully.']);
} else {
    // Insert new cart entry
    $insert = $con->query("INSERT INTO cart (user_id, product_id, quantity) VALUES ('$user_id', '$product_id', '$quantity')");
    if ($insert) {
        echo json_encode(['status' => 'success', 'message' => 'Product added to cart.']);
    } else {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Failed to add product to cart.', 'error' => $con->error]);
    }
}
?>
