<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'conn.php';
header('Content-Type: application/json');

// 1. Token Check
$headers = apache_request_headers();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : '';
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing or invalid.']);
    exit();
}

$token = $matches[1];
$tokenQuery = $con->query("SELECT * FROM users WHERE auth_token = '$token'");
if (!$tokenQuery || $tokenQuery->num_rows === 0) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Invalid token.']);
    exit();
}

// 2. Method Check
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit();
}

// 3. Input
$data = $_POST;
$requiredFields = ['user_id', 'business_id', 'cat_id', 'subcat_id', 'name', 'description', 'price', 'stock', 'status', 'prod_status', 'product_keyword', 'delivery_date'];
foreach ($requiredFields as $field) {
    if (empty($data[$field])) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => "$field is required."]);
        exit();
    }
}

// 4. Sanitize
$user_id = mysqli_real_escape_string($con, $data['user_id']);
$business_id = mysqli_real_escape_string($con, $data['business_id']);
$cat_id = mysqli_real_escape_string($con, $data['cat_id']);
$subcat_id = mysqli_real_escape_string($con, $data['subcat_id']);
$name = mysqli_real_escape_string($con, $data['name']);
$description = mysqli_real_escape_string($con, $data['description']);
$price = mysqli_real_escape_string($con, $data['price']);
$stock = mysqli_real_escape_string($con, $data['stock']);
$status = mysqli_real_escape_string($con, $data['status']);
$prod_status = mysqli_real_escape_string($con, $data['prod_status']);
$product_keyword = mysqli_real_escape_string($con, $data['product_keyword']);
$delivery_date = mysqli_real_escape_string($con, $data['delivery_date']);
$prod_desc = isset($data['prod_desc']) ? mysqli_real_escape_string($con, $data['prod_desc']) : '';
$bonus = isset($data['bonus']) ? mysqli_real_escape_string($con, $data['bonus']) : '';
$prod_color = isset($data['prod_color']) ? mysqli_real_escape_string($con, $data['prod_color']) : '';

// 5. Existence Checks
function checkExists($con, $table, $column, $value) {
    $query = $con->query("SELECT $column FROM $table WHERE $column = '$value'");
    return $query && $query->num_rows > 0;
}

if (!checkExists($con, 'users', 'user_id', $user_id)) {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'User not found.']);
    exit();
}
if (!checkExists($con, 'categories', 'cat_id', $cat_id)) {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'Category not found.']);
    exit();
}
if (!checkExists($con, 'subcat', 'subcat_id', $subcat_id)) {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'Subcategory not found.']);
    exit();
}
if (!checkExists($con, 'business_profiles', 'business_id', $business_id)) {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'Business not found.']);
    exit();
}

// 6. Upload Images
$uploadDir = 'uploads/products/';

function uploadImage($fileKey, $uploadDir) {
    if (isset($_FILES[$fileKey]) && $_FILES[$fileKey]['error'] === UPLOAD_ERR_OK) {
        $tmpName = $_FILES[$fileKey]['tmp_name'];
        $ext = pathinfo($_FILES[$fileKey]['name'], PATHINFO_EXTENSION);
        $fileName = uniqid($fileKey . "_", true) . '.' . $ext;
        $destination = $uploadDir . $fileName;

        if (move_uploaded_file($tmpName, $destination)) {
            return 'https://errandly.org/errandly/' . $destination;  // ✅ Full image URL
        }
    }
    return '';
}


$prod_image1 = uploadImage('prod_image1', $uploadDir);
$prod_image2 = uploadImage('prod_image2', $uploadDir);
$product_image3 = uploadImage('product_image3', $uploadDir);

// 7. Generate product_id
$product_id = 'PROD_' . strtoupper(bin2hex(random_bytes(5)));

// 8. Insert Product
$insertQuery = "INSERT INTO product (
    product_id, business_id, name, description, price, stock, cat_id, subcat_id, 
    prod_image1, status, created_at, updated_at, variants, reviews, images, 
    prod_status, product_keyword, delivery_date, prod_image2, 
    product_image3, bonus, prod_color, user_id
) VALUES (
    '$product_id', '$business_id', '$name', '$description', '$price', '$stock', '$cat_id', '$subcat_id', 
    '$prod_image1', '$status', NOW(), NOW(), '', '', '', 
    '$prod_status', '$product_keyword', '$delivery_date', '$prod_image2', 
    '$product_image3', '$bonus', '$prod_color', '$user_id'
)";

if ($con->query($insertQuery)) {
    // 9. Fetch Joined Product Details
    $productDetailsQuery = $con->query("
        SELECT 
            p.*, 
            c.name, 
            s.name, 
            b.business_name, b.business_email, b.business_phone, 
            u.name, u.email, u.phone
        FROM product p
        LEFT JOIN categories c ON p.cat_id = c.cat_id
        LEFT JOIN subcat s ON p.subcat_id = s.subcat_id
        LEFT JOIN business_profiles b ON p.business_id = b.business_id
        LEFT JOIN users u ON p.user_id = u.user_id
        WHERE p.product_id = '$product_id'
    ");

    if ($productDetailsQuery && $productDetailsQuery->num_rows > 0) {
        $productDetails = $productDetailsQuery->fetch_assoc();
        echo json_encode([
            'status' => 'success',
            'message' => 'Product created successfully.',
            'product' => $productDetails
        ]);
    } else {
        http_response_code(500);
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to retrieve product details.'
        ]);
    }
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Product creation failed.', 'error' => $con->error]);
}
?>
