<?php
require_once 'conn.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php';

header('Content-Type: application/json');

// 🔐 Get Bearer token
$headers = apache_request_headers();
$authHeader = $headers['Authorization'] ?? '';

if ($authHeader && preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    $token = $matches[1];

    $userQuery = $con->query("SELECT user_id, name, email, phone FROM users WHERE auth_token = '$token'");
    if (!$userQuery || $userQuery->num_rows === 0) {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Invalid token']);
        exit();
    }

    $user = $userQuery->fetch_assoc();
    $user_id = $user['user_id'];
    $user_name = $user['name'];
    $user_email = $user['email'];
    $user_phone = $user['phone'];
} else {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Missing or malformed Authorization header']);
    exit();
}

// ✅ Ensure POST method
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
    exit();
}

// 🔄 Get and validate input
$data = json_decode(file_get_contents("php://input"), true);
if (empty($data['user_id']) || empty($data['call_line']) || empty($data['note'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'user_id, call_line and note are required']);
    exit();
}

if ($data['user_id'] !== $user_id) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'user_id does not match the authenticated user']);
    exit();
}

$call_line = $con->real_escape_string($data['call_line']);
$note = $con->real_escape_string($data['note']);
$status = 'pending';

// 🆔 Generate unique booking ID
function generateBookingId($con) {
    do {
        $random = rand(1000, 9999);
        $id = "HTLBOOK-" . $random;
        $check = $con->query("SELECT book_hotel_id FROM hotel_bookings WHERE book_hotel_id = '$id'");
    } while ($check && $check->num_rows > 0);
    return $id;
}

$book_hotel_id = generateBookingId($con);

// 💾 Insert booking
$stmt = $con->prepare("
    INSERT INTO hotel_bookings (
        book_hotel_id, user_id, call_line, user_name, user_phone, user_email, note, status, created_at
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())
");

$stmt->bind_param("ssssssss", $book_hotel_id, $user_id, $call_line, $user_name, $user_phone, $user_email, $note, $status);

if ($stmt->execute()) {
    // 📧 Send email
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'mail.errandly.org';
        $mail->SMTPAuth = true;
        $mail->Username = 'info@errandly.org';
        $mail->Password = 'Zuo$cZs5}^7!';
        $mail->SMTPSecure = 'ssl';
        $mail->Port = 465;

        $mail->setFrom('info@errandly.org', 'Errandly');
        $mail->addAddress($user_email, $user_name);
        $mail->isHTML(true);
        $mail->Subject = 'Hotel Booking Confirmation';
        $mail->Body = "
            <h3>Hi {$user_name},</h3>
            <p>Your hotel booking has been successfully received and is currently <strong>pending</strong>.</p>
            <p><strong>Booking ID:</strong> {$book_hotel_id}</p>
            <p><strong>Call Line:</strong> <a href='{$call_line}'>{$call_line}</a></p>
            <p><strong>Note:</strong> {$note}</p>
            <br>
            <p>Thank you for booking with us!</p>
        ";
        $mail->send();
    } catch (Exception $e) {
        error_log("Email sending failed: " . $mail->ErrorInfo);
    }

    // ✅ Response
    echo json_encode([
    'status' => 'success',
    'message' => 'Hotel booking created successfully',
    'data' => [
        'book_hotel_id' => $book_hotel_id,
        'user_id' => $user_id,
        'user_name' => $user_name,
        'user_email' => $user_email,
        'user_phone' => $user_phone,
        'call_line' => $call_line,
        'note' => $note,
        'status' => $status
    ]
]);

    ]);
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to create hotel booking', 'error' => $con->error]);
}

$stmt->close();
?>
